/*---------------------------------------------*\
|  Color Nokia LCD Text Library					|
| This library contains a small 6x8 bitmap font |
| that can be used to write text on graphic LCD	|
| displays such as the common Nokia 132x132 	|
| screen.  The stock code is designed for the	|
| Philips controller though should be easily	|
| modified for other graphic LCD's.				|
|												|
| Adam Honse (CalcProgrammer1) 3-17-2011		|
\*---------------------------------------------*/

#ifndef COLOR_LCD_TEXT_H
#define COLOR_LCD_TEXT_H

#include "color_lcd.h"
#include <avr/pgmspace.h>

//Print Character
//	-Prints single character <text> in color <color> at position <x>,<y>
//	-Uses 6x8 bitmap font, overwrites pixels
void color_lcd_print_char(char text, int color, unsigned char x, unsigned char y);

//Print String
//	-Prints <length> characters from string <text> in color <color> at position <x>,<y>
//  -Uses 6x8 bitmap font, overwrites pixels
void color_lcd_print_string(char * text, char length, int color, unsigned char x, unsigned char y);

#endif
